<?php
// Start the session to get the user_id
session_start();

// Include the database connection
include('db.php'); // Assuming you have a db.php file for DB connection

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.',
        'cart_count' => 0
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']);


// Query to get cart data with product, category, and variant details
$query = "
    SELECT 
        c.Cart_id,
        c.Quantity,
        c.Created_Date,
        p.Product_id,
        p.Product_name,
        p.Product_image,
        p.Price,
        p.MRP,
        p.Selling_price,
        p.qty,
        p.tax,
        p.Tax_percentage,
        p.Discount_percentage,
        p.Discount_value,
        c.Category,
        c.Variant
    FROM 
        cart c
    INNER JOIN 
        product p ON c.Product_id = p.Product_id AND p.mode = 1 AND p.Delete_status = 0
   
    WHERE 
        c.User_id = '$user_id' AND c.Delete_status = 0
";

// Debugging: print the query to see if it's correct
// echo $query;

// Execute the query
$result = mysqli_query($conn, $query);

// Check if the query was successful
if ($result) {
    // Fetch all results into an associative array
    $cart_data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $cart_data[] = [
            'cart_id' => $row['Cart_id'],
            'product_id' => $row['Product_id'],
            'product_name' => $row['Product_name'],
            'product_image' => $row['Product_image'],
            'price' => $row['Price'],
            'mrp' => $row['MRP'],
            'selling_price' => $row['Selling_price'],
            'qty' => $row['qty'],
            'tax' => $row['tax'],
            'tax_percentage' => $row['Tax_percentage'],
            'discountpercentage' => $row['Discount_percentage'],
            'discountvalue' => $row['Discount_value'],
            'category_name' => $row['category'],
            'variant_color' => $row['Variant'],
            'quantity' => $row['Quantity'],
            'created_date' => $row['Created_Date']
        ];
    }

    // Check if cart data is empty
    if (!empty($cart_data)) {
        echo json_encode([
            'status' => 'success',
            'data' => $cart_data
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No products found in the cart.'
        ]);
    }
} else {
    // Handle query error
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch cart data.',
        'error' => mysqli_error($conn)
    ]);
}

// Close the database connection
mysqli_close($conn);
?>
